clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

linea=1.5;
%%
fmin=2;
fmax=60;
Test=1;
p_rel=3; %bar
carico=415;
meato=64;
Caricamento=['load NW_D65_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) '.txt;'];
eval(Caricamento)
Dati=['dati=NW_D65_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) ';'];
eval(Dati)

%Dati Acquisizione
fs=2000; %Frequenza di campionamento
dt=1/fs;
% dati=dati(inizio*fs:fine*fs,:);
x1=dati(:,1)-mean(dati(:,1));
x2=dati(:,2)-mean(dati(:,2));
x3=dati(:,3)-mean(dati(:,3));
x4=dati(:,4)-mean(dati(:,4));
Force=dati(:,5);
Q=dati(:,6)-mean(dati(:,6));

xm=(x1+x2+x3+x4)./4;
t=[1:length(xm)]*dt;



figure
plot(t,xm,'b','linewidth',linea),
legend('Mean'),
xlabel('t (s)'),ylabel('Displacement ($\mu m$)'),grid on

figure
plot(t,Force,'r','linewidth',linea),
legend('Force (N)'),
xlabel('t (s)'),ylabel('Force (N)'),grid on


Force=Force-mean(Force);

T_wind=2;
window=2^nextpow2(T_wind*fs);
NOVERLAP=round(97*window/100);
[Txym,Fm]=tfestimate(-xm,Force,window,NOVERLAP,[],fs);
[Cxym,Fm] = mscohere(-xm,Force,window,NOVERLAP,[],fs);
[Txy,F]=tfestimate(-x1,Force,window,NOVERLAP,[],fs);
[Cxy,F] = mscohere(-x1,Force,window,NOVERLAP,[],fs);


% [Txym,Fm]=tfestimate(Force,-xm,window,NOVERLAP,[],fs);
% [Cxym,Fm] = mscohere(Force,-xm,window,NOVERLAP,[],fs);
% [Txy,F]=tfestimate(Force,-xm,window,NOVERLAP,[],fs);
% [Cxy,F] = mscohere(Force,-xm,window,NOVERLAP,[],fs);

figure
spectrogram(xm),title('Spectrogram of xm')
xlim([fmin fmax]),xlabel('Frequency (Hz)'),ylabel('Time (s)')

figure
spectrogram(Force),title('Spectrogram of F')
xlim([fmin fmax]),xlabel('Frequency (Hz)'),ylabel('Time (s)')

%%% Bisognerebbe tenere conto anche dell'inerzia associata al pattino e al
%%% sistema di carico
% k=real(Txy);
% cw=imag(Txy);
% c=cw./(F*2*pi);
% 
% km=real(Txym);
% cwm=imag(Txym);
% cm=cwm./(Fm*2*pi);

k=-abs(Txy).*cos(-angle(Txy));
cw=-abs(Txy).*sin(-angle(Txy));
c=cw./(F*2*pi);

km=-abs(Txym).*cos(-angle(Txym));
cwm=-abs(Txym).*sin(-angle(Txym));
cm=cwm./(Fm*2*pi);



figure
plot(F,k,'b',Fm,km,'r','linewidth',1.5),
xlabel('f (Hz)'),ylabel('Stiffness k ($\frac{N}{\mu m}$)')
grid on,xlim([fmin fmax])

figure
plot(F,c,'b',Fm,cm,'r','linewidth',1.5),
xlabel('f (Hz)'),ylabel('Damping c ($\frac{Ns}{\mu m}$)'),
grid on,xlim([fmin fmax])

figure
plot(F,Cxy,'b',Fm,Cxym,'r','linewidth',1.5)
xlabel('f (Hz)'),ylabel('$C_{xy}$'), 
grid on,xlim([fmin fmax])
%% 


figure
subplot(2,1,1)
plot(F,abs(Txy),'b',Fm,abs(Txym),'r','linewidth',2)
subplot(2,1,1)
plot(F,abs(Txy),'b',Fm,abs(Txym),'r','linewidth',2)
xlabel('f (Hz)'),ylabel('$\frac{F_0}{h_0}$ ($\frac{N}{\mu m}$)')
xlim([fmin fmax])
grid on
subplot(2,1,2)
plot(F,angle(Txy)/pi*180,'b',Fm,angle(Txym)/pi*180,'r','linewidth',1.5)
xlabel('f (Hz)'),ylabel('$\varphi$ ($^{\circ}$)')
xlim([fmin fmax])
grid on


%% Salvataggio parametrizzato
Stringa_f=['f_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) '=Fm;'];
Stringa_k=['k_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) '=km;'];
Stringa_c=['c_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) '=cm;'];
Stringa_Mag=['Mag_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) '=abs(Txym);'];
Stringa_Phase=['Phase_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) '=angle(Txym)/pi*180;'];


eval(Stringa_f)
eval(Stringa_k)
eval(Stringa_c)
eval(Stringa_Mag)
eval(Stringa_Phase)

Save=['save NW_D65_Ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test)  ' f_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) ...
      ' k_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) ' c_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) ...
      ' Mag_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test) ' Phase_ps' num2str(p_rel*100) '_F' num2str(carico) '_h' num2str(meato) '_' num2str(Test)];

eval(Save)